//
// (c) 2020 wesolutions GmbH
// All rights reserved.
//

import QtQuick 2.12
import QtQuick.Layouts 1.12

import wesual.Stage 1.0
import wesual.Ui    1.0

RowLayout {
    id : toggle

    property SizeInfo size : Size.defaultSize()

    readonly property int orientation : size.orientation

    signal transposeOrientation()

    spacing : 0

    UiCheckButton {
        bindable : true
        iconName : "aspect-ratio-landscape"
        implicitWidth : 28
        implicitHeight : 28
        checked : toggle.orientation === SizeInfo.Landscape
        visible : toggle.orientation !== SizeInfo.Quadratic

        onClicked : {
            if (!checked) {
                toggle.transposeOrientation();
            }
        }
    }

    UiCheckButton {
        bindable : true
        iconName : "aspect-ratio-portrait"
        implicitWidth : 28
        implicitHeight : 28
        checked : toggle.orientation === SizeInfo.Portrait
        visible : toggle.orientation !== SizeInfo.Quadratic

        onClicked : {
            if (!checked) {
                toggle.transposeOrientation();
            }
        }
    }

    Item {
        implicitWidth : 20
        implicitHeight : 28
        visible : toggle.orientation === SizeInfo.Quadratic

        UiIcon {
            anchors.centerIn : parent

            iconName : "aspect-ratio-quadratic"
        }
    }

    UiText {
        text : toggle.size.orientationName + " " + toggle.size.aspectRatioName

        Layout.fillWidth : true
        Layout.leftMargin : 4
    }
}
